//
//  OnePasswordCore.h
//  OnePasswordCore
//
//  Created by Roustem Karimov on 2014-06-14.
//  Copyright (c) 2014 AgileBits. All rights reserved.
//
@import Foundation;

#if TARGET_OS_IPHONE
@import UIKit;
#else
@import Cocoa;
#endif

//! Project version number for OnePasswordCore.
FOUNDATION_EXPORT double OnePasswordCoreVersionNumber;

//! Project version string for OnePasswordCore.
FOUNDATION_EXPORT const unsigned char OnePasswordCoreVersionString[];

#import <OnePasswordCore/OnePasswordCoreConstants.h>
#import <OnePasswordCore/OPLocalization.h>
#import <OnePasswordCore/OPUserSettings.h>
#import <OnePasswordCore/NSURL+Agile.h>
#import <OnePasswordCore/OPGlobals.h>
#import <OnePasswordCore/OPURLTools.h>
#import <OnePasswordCore/NSURL+AgileBitsCacheFly.h>

#if !TARGET_OS_WATCH
#import <OnePasswordCore/OnePasswordCoreNotifications.h>
#import <OnePasswordCore/OnePasswordWiFiSyncConstants.h>

#import <OnePasswordCore/NSError+Agile.h>
#import <OnePasswordCore/NSURLComponents+Agile.h>
#import <OnePasswordCore/OPAESKey.h>
#import <OnePasswordCore/OPSymmetricKey.h>
#import <OnePasswordCore/OPCryptoUtils.h>
#import <OnePasswordCore/OPKeyPair.h>
#import <OnePasswordCore/OPPublicKey.h>
#import <OnePasswordCore/OPPrivateKey.h>
#import <OnePasswordCore/OPOpenSSLKey.h>
#import <OnePasswordCore/OPAppStoreReceipt.h>
#import <OnePasswordCore/OPAppStoreInAppPurchase.h>
#import <OnePasswordCore/OPApplicationCustomer.h>
#import <OnePasswordCore/OPAppStore.h>
#import <OnePasswordCore/OPAppStoreProduct.h>
#import <OnePasswordCore/OPRateLimiter.h>
#import <OnePasswordCore/OPJSONWebKey.h>
#import <OnePasswordCore/OPKeySet.h>
#import <OnePasswordCore/OPImageProcess.h>

#import <OnePasswordCore/OPXAuth.h>
#import <OnePasswordCore/OPXSMAAuth.h>
#import <OnePasswordCore/OPXPayloadKey.h>

#import <OnePasswordCore/OPLocalization.h>
#import <OnePasswordCore/OPUserSettings.h>
#import <OnePasswordCore/AGPasswordUtils+OnePassword.h>
#import <OnePasswordCore/NSDate+OnePassword.h>

#import <OnePasswordCore/OPNewsletterSignupService.h>
#import <OnePasswordCore/OPBrain.h>

#import <OnePasswordCore/OPNetworkQueue.h>

#import <OnePasswordCore/OPAppLinks.h>

#import <OnePasswordCore/B5PersonalKey.h>
#import <OnePasswordCore/B5PasswordUtils.h>
#import <OnePasswordCore/OPFileSystemMonitor.h>
#import <OnePasswordCore/OPEncryptedString.h>

#import <OnePasswordCore/OPWebStoreCouponGenerator.h>

#import <OnePasswordCore/SRWebSocket.h>

#import <OnePasswordCore/NSString+BIGNUM.h>
#import <OnePasswordCore/OPUserMessage.h>
#endif

#if TARGET_OS_IOS
#import <OnePasswordCore/IOSConstants.h>
#import <OnePasswordCore/NSAttributedString+AgileBits.h>
#import <OnePasswordCore/OnePasswordUI_iOS.h>
#import <OnePasswordCore/UIDevice+AgileBits.h>
#import <OnePasswordCore/UIFont+AgileBits.h>
#import <OnePasswordCore/UIView+AgileBits.h>
#import <OnePasswordCore/UIViewController+AgileBits.h>
#import <OnePasswordCore/UITableView+AgileBits.h>
#import <OnePasswordCore/OPSyncStatusMonitor.h>
#import <OnePasswordCore/OPUserMessage.h>
#import <OnePasswordCore/OPPasteboardHelper.h>
#endif

#if TARGET_OS_IPHONE
#import <OnePasswordCore/AGLoggerSettings_iOS.h>
#endif

#if !TARGET_OS_IPHONE
#import <OnePasswordCore/OnePasswordCoreNotifications_Mac.h>
#import <OnePasswordCore/OSXConstants.h>
#import <OnePasswordCore/AGLoggerSettings_Mac.h>
#import <OnePasswordCore/NSColor+OnePassword.h>
#import <OnePasswordCore/NSShadow+OnePassword.h>
#import <OnePasswordCore/OPLicense.h>
#import <OnePasswordCore/OPReceiptMigrator.h>
#endif
